
#ifndef SEC_BOOT_ERROR_H
#define SEC_BOOT_ERROR_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "DX_VOS_BaseTypes.h"


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Wed Feb 23 21:00:47 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version error.h#1:incl:2
   *  \author adams
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/************************ Defines ******************************/

/* error definitions */
#define DX_OK                                    0
#define DX_VRL_PRIMARY_INTEGRITY_FAILURE         0xF0000000
#define DX_VRL_SECONDARY_INTEGRITY_FAILURE       0xF0000001
#define DX_INVALID_PRIMARY_VRL_MAGIC_NUM_VAL     0xF0000002
#define DX_INVALID_SECONDARY_VRL_MAGIC_NUM_VAL   0xF0000003
#define DX_SECURE_MODE_IS_NOT_ACTIVE             0xF0000004
#define DX_INVALID_HASH_QUEUE_SIZE_ERROR         0xF0000005
#define DX_PUB_KEY_HASH_VALIDATION_FAILURE       0xF0000006
#define DX_INTERNAL_ERROR                        0xF000000F
#define DX_RECORD_INTEGRITY_FAILURE( Table , N ) ( ((Table) + 1)*0x10000000 + (N) )                                    

/* the discretix error definition */
typedef DxUint32_t DX_Error_t;

/************************ Enums ********************************/


/************************ Typedefs  ****************************/


/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/


#ifdef __cplusplus
}
#endif

#endif

